#ifndef _HANDSHAKE_CPP
#define _HANDSHAKE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedClasses/CRC32/CRC.H"
#include "../../SharedClasses/SQLClass/SQLClass.H"
#include "../../SharedClasses/SQLClass/SQLRoutines.H"

#include "../SockServer/SockServer.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "HandShake.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsValidCompanyAccount(SocketServer *pSockSrvr, int iClient);
int IsValidClientVersion(SocketServer *pSockSrvr, int iClient, char *UpdateHTTPURL);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void BinPrint(const char *sData, int iLen)
{
	int iRPos = 0;
	while(iRPos < iLen)
	{
		printf("%X\n", sData[iRPos]);
		iRPos++;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	int PerformHandShake(int iClient, char *sRecvBuf, int iRecvBufSz)

	Performs a hand shake. Also know as Client/Server Authentication.

	Possible return Values:
		AUTH_FAILED   //The authentication process failed.
		AUTH_SUCCESS  //The authentication process was a success.
		AUTH_OK       //The authentication process is still in process, all is well.
		AUTH_ERROR    //The authentication process failed due to an error.
*/
int PerformHandShake(SocketServer *pSockSrvr, int iClient, char *sCmdBuf, int iCmdBufSz)
{
    char sCmdData[RECEIVEBUFSZ + 1];
    char sSendBuf[MAXSENDBUFSZ + 1];
	char sTemp[MAXSENDBUFSZ];

	int iSendBufSz = 0;
	int iCmdDataSz = 0;
	int iCmdFlagLength = 0;

    if((iCmdFlagLength = CmdCmp(sCmdBuf, "::AuthString->")))
    {
		if(CCI[iClient].iAuthStep != 0)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.");
			return AUTH_ERROR;
		}
		else CCI[iClient].iAuthStep++;

		char sNewAuthKey_Crypt[MAX_KEY_LENGTH];
		char sNewAuthKey[MAX_KEY_LENGTH];

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		WriteLog(pSockSrvr->icClientID[iClient], "Initializing Cryptography Set...");
		memset(&CCI[iClient].MyCrypt, 0, sizeof(CCI[iClient].MyCrypt));
		if(CCI[iClient].MyCrypt.InitializeCryptographySet(gsAuthKey, strlen(gsAuthKey), CRYPTFLAGS))
		{
			CCI[iClient].bIsEncryptionInit = true;
		}
		else{
			CCI[iClient].bIsEncryptionInit = false;
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to failure to initialize cryptography.");
			return AUTH_ERROR;
		}

		CCI[iClient].MyCrypt.Decode(sCmdData, sTemp, iCmdDataSz);
		sTemp[iCmdDataSz] = '\0';

		WriteLog(pSockSrvr->icClientID[iClient], "Received authentication string.");

		if(strcmp(sTemp, gsAuthString) != 0)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication String.");
			pSockSrvr->SetNextSendData(iClient, "::AuthenticationFailed");
			return AUTH_FAILED;
		}
		
		WriteLog(pSockSrvr->icClientID[iClient], "Validation of Authentication String verified.");
		
		if(!GenerateKey(giKeyGenLength, (GetTickCount()+iClient), GKUPPER_AZ|GKNUMBERS|GKNONREPETITION, sNewAuthKey))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed failure to generate a key.");
			pSockSrvr->SetNextSendData(iClient, "::AuthenticationFailed");
			return AUTH_ERROR;
		}

		CCI[iClient].MyCrypt.Encode(sNewAuthKey, sNewAuthKey_Crypt, giKeyGenLength);
		CCI[iClient].MyCrypt.UninitializeCryptographySet();
		memset(&CCI[iClient].MyCrypt, 0, sizeof(CCI[iClient].MyCrypt));

		if(!CCI[iClient].MyCrypt.InitializeCryptographySet(sNewAuthKey, giKeyGenLength, CRYPTFLAGS))
		{
			
		}

		iSendBufSz = AppendDataToCmd("::NewAuthKey->", sNewAuthKey_Crypt, giKeyGenLength, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);

		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::NewKeyAuth->")))
    {
		if(CCI[iClient].iAuthStep != 1)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.");
			return AUTH_ERROR;
		}
		else CCI[iClient].iAuthStep++;

		WriteLog(pSockSrvr->icClientID[iClient], "Received new key Authentication string.");

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		CCI[iClient].MyCrypt.Decode(sCmdData, sTemp, iCmdDataSz);
		sTemp[iCmdDataSz] = '\0';

		if(strcmp(sTemp, gsAuthString) != 0)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid key.");
			pSockSrvr->SetNextSendData(iClient, "::AuthenticationFailed");
			return AUTH_FAILED;
		}
		
		WriteLog(pSockSrvr->icClientID[iClient], "Encryption key exchange complete.");

		pSockSrvr->SetNextSendData(iClient, "::RequestVersion");
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Version->")))
    {
		if(CCI[iClient].iAuthStep != 2)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.");
			return AUTH_ERROR;
		}
		else CCI[iClient].iAuthStep++;

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		CCI[iClient].MyCrypt.Decode(sCmdData, sCmdData, iCmdDataSz);
		sCmdData[iCmdDataSz] = '\0';

		strcpy(CCI[iClient].sClientVersion, sCmdData); // Svae the client version.

		sprintf(sTemp, "Client Version: %s", sCmdData);
		WriteLog(pSockSrvr->icClientID[iClient], sTemp);

		if(CCI[iClient].IndexDB.DBConnect(gsSQLIndexDriver, gsSQLIndexServer, gsSQLIndexUserID, gsSQLIndexPassword, gsSQLIndexDatabase))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Successfully connected to the Index database.");
			CCI[iClient].bWPIndexConnected = true;
		}
		else{
			WriteLog(pSockSrvr->icClientID[iClient], "Failed to connect to the Index database.");
			return AUTH_ERROR;
		}

        char sUpdateHTTPURL[1024 + 1];

        int iCVResult = IsValidClientVersion(pSockSrvr, iClient, sUpdateHTTPURL);
        if(iCVResult == CLIENTVER_CURRENT){
			WriteLog(pSockSrvr->icClientID[iClient], "Client software is up-to-date.");
			pSockSrvr->SetNextSendData(iClient, "::RequestCompanyName");
            return AUTH_OK;
        }
        else if(iCVResult == CLIENTVER_SUPPORTED){
			WriteLog(pSockSrvr->icClientID[iClient], "Client software is outdated but still supported. Update soon!");
			pSockSrvr->SetNextSendData(iClient, "::RequestCompanyName");
            return AUTH_OK;
        }
        else if(iCVResult == CLIENTVER_OUTDATED){
			WriteLog(pSockSrvr->icClientID[iClient], "Client software is outdated. Update now!");
            return AUTH_ERROR;
        }
        else if(iCVResult == CLIENTVER_AUTOUPDATE){
			WriteLog(pSockSrvr->icClientID[iClient], "Performing client autoupdate.");

            sprintf(sTemp, "::AutoUpdate:%s", sUpdateHTTPURL);
            pSockSrvr->SetNextSendData(iClient, sTemp);
            return AUTH_ERROR;
        }
        else{
			WriteLog(pSockSrvr->icClientID[iClient], "Error verifing client version.");
            return AUTH_ERROR;
        }

		pSockSrvr->SetNextSendData(iClient, "::RequestCompanyName");
		return AUTH_ERROR;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::CompanyName->")))
    {
		if(CCI[iClient].iAuthStep != 3)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.");
			return AUTH_ERROR;
		}
		else CCI[iClient].iAuthStep++;

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		CCI[iClient].MyCrypt.Decode(sCmdData, sCmdData, iCmdDataSz);
		sCmdData[iCmdDataSz] = '\0';

		strcpy(CCI[iClient].sCompanyName, sCmdData); // Svae the company name;
	
		sprintf(sTemp, "Company Name: %s", sCmdData);
		WriteLog(pSockSrvr->icClientID[iClient], sTemp);

		pSockSrvr->SetNextSendData(iClient, "::RequestPassword");
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Password->")))
    {
		if(CCI[iClient].iAuthStep != 4)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.");
			return AUTH_ERROR;
		}
		else CCI[iClient].iAuthStep++;

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		CCI[iClient].MyCrypt.Decode(sCmdData, sCmdData, iCmdDataSz);
		sCmdData[iCmdDataSz] = '\0';

		strcpy(CCI[iClient].sPassword, sCmdData); // Svae the password;

		sprintf(sTemp, "Password: %s", sCmdData);
		WriteLog(pSockSrvr->icClientID[iClient], sTemp);

        if(!IsValidCompanyAccount(pSockSrvr, iClient))
        {
			WriteLog(pSockSrvr->icClientID[iClient], "Invalid company account.");
			pSockSrvr->SetNextSendData(iClient, "::AuthenticationFailed");
            return AUTH_FAILED;
        }

		WriteLog(pSockSrvr->icClientID[iClient], "Authentication success.");
		pSockSrvr->SetNextSendData(iClient, "::AuthenticationSuccess");
		return AUTH_SUCCESS;
	}

	return AUTH_ERROR;	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsValidCompanyAccount(SocketServer *pSockSrvr, int iClient)
{
    char sStatement[255];

    HSTMT StatementHandle = NULL;

    sprintf(sStatement, "SELECT CompanyDatabase FROM Companys WHERE CompanyName = '%s' AND CompanyPassword = '%s'", CCI[iClient].sCompanyName, CCI[iClient].sPassword);
	if(!CCI[iClient].IndexDB.DBExecute(sStatement, &StatementHandle))
    {
        WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidCompanyPassword :: DBexecute failed.");
        return false;
    }

    SQLINTEGER outRowCount = 0;
    if(SQLRowCount(StatementHandle, &outRowCount) != SQL_SUCCESS)
    {
        WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidCompanyPassword :: SQLRowCount failed.");

        DBCloseCursor(StatementHandle);
        return false;
    }

    if(outRowCount < 1) //No matching company name and password
	{
		DBCloseCursor(StatementHandle);
		return false;
	}

    if(!DBFetch(StatementHandle))
    {
        WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidCompanyPassword :: DBFetch failed.");

        DBCloseCursor(StatementHandle);
        return false;
    }

    SQLINTEGER DataLength = 0;
    SQLCHAR SQLBuffer[25 + 1];

    if(!DBGetData(StatementHandle, 1, SQL_C_CHAR, SQLBuffer, 25, &DataLength))
    {
        WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidCompanyPassword :: DBGetData failed.");

        DBCloseCursor(StatementHandle);
        return false;
    }

    if(DataLength == -1)
	{
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidCompanyPassword :: DBGetData returned -1.");
		DBCloseCursor(StatementHandle);
		return false;
	}

    memcpy(CCI[iClient].sCompanyDatabase, SQLBuffer, DataLength); //Save the company database name.
	CCI[iClient].sCompanyDatabase[DataLength] = '\0';

    DBCloseCursor(StatementHandle);

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int IsValidClientVersion(SocketServer *pSockSrvr, int iClient, char *sUpdateHTTPURL)
{
    char sStatement[255];

    HSTMT StatementHandle = NULL;

	sprintf(sStatement, "SELECT Status, UpdateURL FROM ClientVersions WHERE Version = '%s'", CCI[iClient].sClientVersion);

	if(!CCI[iClient].IndexDB.DBExecute(sStatement, &StatementHandle))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: DBExecute failed.");
        return CLIENTVER_ERROR;
    }

    SQLINTEGER outRowCount = 0;
    if(SQLRowCount(StatementHandle, &outRowCount) != SQL_SUCCESS)
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: SQLRowCount failed.");

        DBCloseCursor(StatementHandle);
        return CLIENTVER_ERROR;
    }

    if(outRowCount == 0)
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: Unknown client version.");

        DBCloseCursor(StatementHandle);
        return CLIENTVER_ERROR;
    }

    if(!DBFetch(StatementHandle))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: DBFetch failed.");

        DBCloseCursor(StatementHandle);
        return CLIENTVER_ERROR;
    }

    SQLINTEGER DataLength = 0;
    SQLCHAR ClientVersion[25 + 1];

    if(!DBGetData(StatementHandle, 1, SQL_C_CHAR, ClientVersion, 25, &DataLength))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: DBGetData 1 failed.");

        DBCloseCursor(StatementHandle);
        return CLIENTVER_ERROR;
    }
	if(DataLength > 0 && DataLength <= 25)
	{
		ClientVersion[DataLength] = '\0';
	}

    if(!DBGetData(StatementHandle, 2, SQL_C_CHAR, sUpdateHTTPURL, 1024, &DataLength))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: DBGetData 2 failed.");

        DBCloseCursor(StatementHandle);
        return CLIENTVER_ERROR;
    }
	if(DataLength > 0 && DataLength <= 1024)
	{
		sUpdateHTTPURL[DataLength] = '\0';
	}

    DBCloseCursor(StatementHandle);

    if(strcmpi((char *)ClientVersion, "current") == 0){ // Current version
        return CLIENTVER_CURRENT;
    }
    else if(strcmpi((char *)ClientVersion, "supported") == 0){ // Old but supported
        return CLIENTVER_SUPPORTED;
    }
    else if(strcmpi((char *)ClientVersion, "outdated") == 0){ // Old and nolonger supported
        return CLIENTVER_OUTDATED;
    }
    else if(strcmpi((char *)ClientVersion, "autoupdate") == 0){ // Old and nolonger supported
        return CLIENTVER_AUTOUPDATE;
    }
    else{
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: Unknown version identifier.");
        return CLIENTVER_ERROR;
    }

    return CLIENTVER_ERROR;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

